/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.xfw.updates;

import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.updates.AbstractUpdateCollection;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MessageText;
import com.ibm.hwmca.xfw.updates.UpdateableComponent;
import java.util.List;
import java.util.Set;

public abstract class UpdateCollection
implements AbstractUpdateCollection,
Comparable {
    public static final int STATE_NOT_PRESENT = 0;
    public static final int STATE_STAGED = 1;
    public static final int STATE_APPLY_IN_PROGRESS = 2;
    public static final int STATE_PARTIALLY_APPLIED = 3;
    public static final int STATE_REJECT_IN_PROGRESS = 4;
    public static final int STATE_APPLIED = 5;
    public static final int STATE_COMMITTED = 6;
    UpdateableComponent owningComponent;
    MessageText lastMessage;
    MessageText lastDetailsMessage;

    protected UpdateCollection(UpdateableComponent owningComponent) {
        this.owningComponent = owningComponent;
    }

    public UpdateableComponent getUpdateableComponent() {
        return this.owningComponent;
    }

    public abstract int getId();

    public abstract List getUpdates();

    public String getDisplayableId() {
        String did = String.valueOf(this.getId());
        if (did.length() >= 3) {
            return did;
        }
        return "000".substring(0, 3 - did.length()) + did;
    }

    public abstract int getState();

    public LocalizableText getDisplayableState() {
        return this.owningComponent.getOwner().getUpdateStyle().getDisplayableUpdateCollectionState(this);
    }

    public abstract Set getPrerequisites();

    public abstract Set getHardPrerequisites();

    public abstract Set getCorequisites();

    public abstract boolean isInTransition();

    public abstract boolean isDisruptive();

    public abstract void apply() throws IllegalStateException, HException;

    public abstract boolean isError();

    public MessageText getLastMessage() {
        MessageText message = this.lastMessage;
        this.lastMessage = null;
        return message;
    }

    protected void setLastMessage(MessageText message) {
        this.lastMessage = message;
    }

    public synchronized MessageText getLastDetailsMessage() {
        MessageText message = this.lastDetailsMessage;
        this.lastDetailsMessage = null;
        return message;
    }

    protected synchronized void setLastDetailsMessage(MessageText message) {
        this.lastDetailsMessage = message;
    }

    public abstract void reject() throws IllegalStateException, HException;

    public abstract void commit() throws IllegalStateException, HException;

    public abstract void delete() throws IllegalStateException, HException;

    public int compareTo(Object o) {
        UpdateCollection collection = (UpdateCollection)o;
        if (this.owningComponent == collection.owningComponent) {
            return this.getId() - collection.getId();
        }
        return this.owningComponent.getECNumber().compareTo(collection.owningComponent.getECNumber());
    }

    public String toString() {
        String className = this.getClass().getName();
        int dot = className.lastIndexOf(46);
        if (dot != -1) {
            className = className.substring(dot + 1);
        }
        return className + '[' + this.getUpdateableComponent().getECNumber() + ',' + this.getId() + ']';
    }
}

